*** Upper Panel of Figure 2


* Actual line

set more off
use /mcr/cps/matched/data/matched.dta, clear

drop if mlr==-1 | mlr==.

collapse (sum) sswgt, by(mdate mlr)
gen wgt=sswgt/(1000)
drop sswgt

reshape wide wgt, i(mdate) j(mlr)

egen pop= rowtotal(wgt*)
gen ret_r=wgt5/pop

tsset mdate, m
tssmooth ma ret_r_12 = ret_r,window(11 1 0)

tsline ret_r_12 if tin(1995m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Not in Labor Force due to Retirement, 12mma") 


* Predicted line

set more off
use /mcr/cps/matched/data/matched.dta, clear

drop if mlr==-1 | mlr==.

collapse (sum) sswgt, by(mdate age mlr)
gen wgt=sswgt/(1000)
drop sswgt

reshape wide wgt, i(mdate age) j(mlr)

gen pop = 0
forval num1=1/7 {
 replace pop = pop + wgt`num1' if !missing(wgt`num1')
}

gen ret_r=0
replace ret_r=wgt5/pop if !missing(wgt5)

drop wgt*

reshape wide pop ret_r, i(mdate) j(age)

tsset mdate, m
format mdate %tm

forvalues age = 16/80 {
  tssmooth ma pop`age'_12 = pop`age',window(11 1 0)
  tssmooth ma ret_r`age'_12 = ret_r`age',window(11 1 0)
}
tssmooth ma pop85_12 = pop85,window(11 1 0)
tssmooth ma ret_r85_12 = ret_r85,window(11 1 0)

keep mdate *_12

forvalues age = 16/80 {
  rename pop`age'_12 pop`age'
  rename ret_r`age'_12  ret_r`age'
}
rename pop85_12 pop85
rename ret_r85_12  ret_r85

keep  if mdate>=tm(2007m12)

egen pop = rowtotal(pop*)

forvalues age = 16/80 {
  gen pop_s`age' = pop`age' / pop
  gen ret_s`age' = ret_r`age' * pop_s`age'
  gen ret07_s`age' = ret_r`age'[1] * pop_s`age'
}

gen pop_s85 = pop85/pop
gen ret_s85 = ret_r85 * pop_s85
gen ret07_s85 = ret_r85[1] * pop_s85

egen ret_r = rowtotal(ret_s*)
egen ret07_r = rowtotal(ret07_s*)

tsline ret_r ret07_r if tin(2007m1, 2014m6), lcolor(dknavy dkgreen) lpattern (solid shortdash) ttitle("") tline(2007m12(1)2009m6, lc(gs12) lw(vvthick)) title("Not in Labor Force due to Retirement, 12mma") legend(label (1 "Actual") label (2 "Predicted by changing age composition"))



*** Bottom Panel of Figure 2

set more off
use /mcr/cps/matched/data/matched.dta, clear

drop if mlr==-1 | mlr==.

collapse (sum) sswgt, by(mdate mlr age)
gen wgt=sswgt/(1000)
drop sswgt

reshape wide wgt, i(mdate age) j(mlr)

gen pop = 0
forval num1=1/7 {
 replace pop = pop + wgt`num1' if !missing(wgt`num1')
}

rename wgt5 ret
drop wgt*

reshape wide ret pop, i(mdate) j(age)

tsset mdate, m

forvalues age = 16/99{
  tssmooth ma pop`age'_12 = pop`age',window(11 1 0)
  tssmooth ma ret`age'_12 = ret`age',window(11 1 0)
  gen ret_rate`age'_12 = ret`age'_12/pop`edu'`age'_12
  label var ret_rate`age'_12 "`age' years"
}

tsline ret_rate55_12 ret_rate60_12 ret_rate62_12 ret_rate65_12 ret_rate66_12 ret_rate70_12 if tin(1995m1, 2014m6), ttitle("") tline(2001m3(1)2001m11 2007m12(1)2009m6, lc(gs12) lw(thick)) title("Retirement Rates by Age, 12mma") 


